Texture2D TexDiffuse : register(t0);
SamplerState sampleDiffuse : register(s0);

Texture2D TexDepth : register(t1);
SamplerState sampleDepth : register(s1);

Texture2D TexShadowMap : register(t2);
SamplerState sampleShadowMap : register(s0);

Texture2D TexToon : register(t3);

Texture2D TexToonDepth : register(t4);

Texture2D TexCollider : register(t5);

cbuffer ConstantBuffer1 : register(b0) {

	matrix	MatWorld;
	matrix	MatView;
	matrix	MatProj;
	matrix	MatWorldShadowMap;
	matrix	MatViewShadowMap;
	matrix	MatProjShadowMap;
	matrix	MatLight;
	matrix	MatProjLight;
	float4	LightColor[16];
	float4	LightPos[16];
	float4	EyePos;
	float4	ShaderParam1;
}

cbuffer ConstantBuffer2 : register(b1) {

	float4 Diffuse;
	float4 Ambient;
	float4 Specular;
	float4 AlphaParam;
}

cbuffer ConstantBuffer3 : register(b2) {

	float4			ToneLightPos;
	matrix			BindShapeMatrix;
	matrix			MatTransform;
	matrix			MatNormalTransform;
	matrix			BoneMatrix[32];
}

cbuffer ConstantBuffer4 : register(b3) {

	float4 ColliderPos[255][2];
	float4 ColliderParam[255];
}

cbuffer ConstantBuffer5 : register(b4) {

	float4 ColliderState;
}

////////////////////////////////////////////////////////

struct VertexIn_1 {

	float3 Pos : POSITION;
	float3 Normal : NORMAL;
	float4 Color : COLOR;
	float2 Tex : TEXCOORD;
	float2 Weight0 : TEXCOORD1;
	float2 Weight1 : TEXCOORD2;
	float2 Weight2 : TEXCOORD3;
	float2 Weight3 : TEXCOORD4;
	float2 Weight4 : TEXCOORD5;
	float2 Weight5 : TEXCOORD6;
	float2 Weight6 : TEXCOORD7;
	float2 Weight7 : TEXCOORD8;
};

struct VertexIn_2 {

	float3 Pos : POSITION;
	float3 Normal : NORMAL;
	float2 Tex : TEXCOORD;
};

struct VertexIn_3 {

	float3 Pos : POSITION;
	float3 Normal : NORMAL;
	float2 Weight0 : TEXCOORD;
	float2 Weight1 : TEXCOORD1;
	float2 Weight2 : TEXCOORD2;
	float2 Weight3 : TEXCOORD3;
	float2 Weight4 : TEXCOORD4;
	float2 Weight5 : TEXCOORD5;
	float2 Weight6 : TEXCOORD6;
	float2 Weight7 : TEXCOORD7;
};

struct VertexOut {

	float4 Pos : SV_POSITION;
	float3 VtxPos : POSITION0;
	float3 Normal : POSITION1;
	float4 Color : COLOR0;
	float2 Tex : TEXCOORD0;
};

struct PsOutput {

	float4 Color : SV_Target0;
	float4 Depth : SV_Target1;
};

/////////////////////////////////////////////////////////////////////

VertexOut vs_main1(VertexIn_1 IN) {

	VertexOut OUT;

	float4 vtx = float4(IN.Pos, 1.0f);
	float4 normal = float4(IN.Normal, 1.0f);
	float4 vtx_tmp = float4(0, 0, 0, 0);
	float4 normal_tmp = float4(0, 0, 0, 0);

	vtx = mul(vtx, BindShapeMatrix);
	normal = mul(normal, BindShapeMatrix);

	int joint0 = (int)(IN.Weight0.x + 0.0001f);
	int joint1 = (int)(IN.Weight1.x + 0.0001f);
	int joint2 = (int)(IN.Weight2.x + 0.0001f);
	int joint3 = (int)(IN.Weight3.x + 0.0001f);
	int joint4 = (int)(IN.Weight4.x + 0.0001f);
	int joint5 = (int)(IN.Weight5.x + 0.0001f);
	int joint6 = (int)(IN.Weight6.x + 0.0001f);
	int joint7 = (int)(IN.Weight7.x + 0.0001f);

	float w0 = clamp(IN.Weight0.y, 0.0f, 1.0f);
	float w1 = clamp(IN.Weight1.y, 0.0f, 1.0f);
	float w2 = clamp(IN.Weight2.y, 0.0f, 1.0f);
	float w3 = clamp(IN.Weight3.y, 0.0f, 1.0f);
	float w4 = clamp(IN.Weight4.y, 0.0f, 1.0f);
	float w5 = clamp(IN.Weight5.y, 0.0f, 1.0f);
	float w6 = clamp(IN.Weight6.y, 0.0f, 1.0f);
	float w7 = clamp(IN.Weight7.y, 0.0f, 1.0f);

	bool add_weight = false;
	float4 v = float4(0, 0, 0, 0);
	float4 n = float4(0, 0, 0, 0);

	if (w0 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint0]);
		n = mul(normal, BoneMatrix[joint0]);
		v *= w0;
		n *= w0;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w1 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint1]);
		n = mul(normal, BoneMatrix[joint1]);
		v *= w1;
		n *= w1;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w2 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint2]);
		n = mul(normal, BoneMatrix[joint2]);
		v *= w2;
		n *= w2;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w3 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint3]);
		n = mul(normal, BoneMatrix[joint3]);
		v *= w3;
		n *= w3;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w4 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint4]);
		n = mul(normal, BoneMatrix[joint4]);
		v *= w4;
		n *= w4;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w5 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint5]);
		n = mul(normal, BoneMatrix[joint5]);
		v *= w5;
		n *= w5;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w6 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint6]);
		n = mul(normal, BoneMatrix[joint6]);
		v *= w6;
		n *= w6;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w7 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint7]);
		n = mul(normal, BoneMatrix[joint7]);
		v *= w7;
		n *= w7;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}

	if (add_weight == true) {
		vtx = vtx_tmp;
		normal = normal_tmp;
	}

	vtx = mul(vtx, MatTransform);
	normal = mul(normal, MatNormalTransform);
	OUT.VtxPos = vtx.xyz;
	vtx = mul(vtx, MatWorld);
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;
	OUT.Normal = normal.xyz;

	OUT.Color = float4(0, 0, 0, 1);
	OUT.Color = IN.Color;
	OUT.Tex = IN.Tex;

	return OUT;
}

VertexOut vs_main2(VertexIn_2 IN) {

	VertexOut OUT;

	OUT.Pos = float4(IN.Pos, 1.0f);
	OUT.Normal = IN.Normal;
	OUT.VtxPos = IN.Pos.xyz;
	OUT.Tex = IN.Tex;

	return OUT;
}

VertexOut vs_main3(VertexIn_2 IN) {

	VertexOut OUT;

	OUT.Pos = float4(IN.Pos, 1.0f);
	OUT.Normal = IN.Normal;
	OUT.VtxPos = IN.Pos.xyz;
	OUT.Tex = IN.Tex;

	return OUT;
}

VertexOut vs_main4(VertexIn_3 IN) {

	VertexOut OUT;

	float4 vtx = float4(IN.Pos, 1.0f);
	float4 normal = float4(IN.Normal, 1.0f);
	float4 vtx_tmp = float4(0, 0, 0, 0);
	float4 normal_tmp = float4(0, 0, 0, 0);

	vtx = mul(vtx, BindShapeMatrix);
	normal = mul(normal, BindShapeMatrix);

	int joint0 = (int)(IN.Weight0.x + 0.0001f);
	int joint1 = (int)(IN.Weight1.x + 0.0001f);
	int joint2 = (int)(IN.Weight2.x + 0.0001f);
	int joint3 = (int)(IN.Weight3.x + 0.0001f);
	int joint4 = (int)(IN.Weight4.x + 0.0001f);
	int joint5 = (int)(IN.Weight5.x + 0.0001f);
	int joint6 = (int)(IN.Weight6.x + 0.0001f);
	int joint7 = (int)(IN.Weight7.x + 0.0001f);

	float w0 = clamp(IN.Weight0.y, 0.0f, 1.0f);
	float w1 = clamp(IN.Weight1.y, 0.0f, 1.0f);
	float w2 = clamp(IN.Weight2.y, 0.0f, 1.0f);
	float w3 = clamp(IN.Weight3.y, 0.0f, 1.0f);
	float w4 = clamp(IN.Weight4.y, 0.0f, 1.0f);
	float w5 = clamp(IN.Weight5.y, 0.0f, 1.0f);
	float w6 = clamp(IN.Weight6.y, 0.0f, 1.0f);
	float w7 = clamp(IN.Weight7.y, 0.0f, 1.0f);

	bool add_weight = false;
	float4 v = float4(0, 0, 0, 0);
	float4 n = float4(0, 0, 0, 0);

	if (w0 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint0]);
		n = mul(normal, BoneMatrix[joint0]);
		v *= w0;
		n *= w0;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w1 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint1]);
		n = mul(normal, BoneMatrix[joint1]);
		v *= w1;
		n *= w1;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w2 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint2]);
		n = mul(normal, BoneMatrix[joint2]);
		v *= w2;
		n *= w2;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w3 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint3]);
		n = mul(normal, BoneMatrix[joint3]);
		v *= w3;
		n *= w3;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w4 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint4]);
		n = mul(normal, BoneMatrix[joint4]);
		v *= w4;
		n *= w4;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w5 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint5]);
		n = mul(normal, BoneMatrix[joint5]);
		v *= w5;
		n *= w5;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w6 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint6]);
		n = mul(normal, BoneMatrix[joint6]);
		v *= w6;
		n *= w6;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w7 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint7]);
		n = mul(normal, BoneMatrix[joint7]);
		v *= w7;
		n *= w7;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}

	if (add_weight == true) {
		vtx = vtx_tmp;
		normal = normal_tmp;
	}

	vtx = mul(vtx, MatTransform);
	normal = mul(normal, MatNormalTransform);
	OUT.VtxPos = vtx.xyz;
	vtx = mul(vtx, MatWorld);
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;
	OUT.Normal = normal.xyz;

	return OUT;
}

VertexOut vs_main5(VertexIn_1 IN) {

	//VhE}bvp

	VertexOut OUT;

	float4 vtx = float4(IN.Pos, 1.0f);
	float4 normal = float4(IN.Normal, 1.0f);
	float4 vtx_tmp = float4(0, 0, 0, 0);
	float4 normal_tmp = float4(0, 0, 0, 0);

	vtx = mul(vtx, BindShapeMatrix);
	normal = mul(normal, BindShapeMatrix);

	int joint0 = (int)(IN.Weight0.x + 0.0001f);
	int joint1 = (int)(IN.Weight1.x + 0.0001f);
	int joint2 = (int)(IN.Weight2.x + 0.0001f);
	int joint3 = (int)(IN.Weight3.x + 0.0001f);
	int joint4 = (int)(IN.Weight4.x + 0.0001f);
	int joint5 = (int)(IN.Weight5.x + 0.0001f);
	int joint6 = (int)(IN.Weight6.x + 0.0001f);
	int joint7 = (int)(IN.Weight7.x + 0.0001f);

	float w0 = clamp(IN.Weight0.y, 0.0f, 1.0f);
	float w1 = clamp(IN.Weight1.y, 0.0f, 1.0f);
	float w2 = clamp(IN.Weight2.y, 0.0f, 1.0f);
	float w3 = clamp(IN.Weight3.y, 0.0f, 1.0f);
	float w4 = clamp(IN.Weight4.y, 0.0f, 1.0f);
	float w5 = clamp(IN.Weight5.y, 0.0f, 1.0f);
	float w6 = clamp(IN.Weight6.y, 0.0f, 1.0f);
	float w7 = clamp(IN.Weight7.y, 0.0f, 1.0f);

	bool add_weight = false;
	float4 v = float4(0, 0, 0, 0);
	float4 n = float4(0, 0, 0, 0);

	if (w0 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint0]);
		n = mul(normal, BoneMatrix[joint0]);
		v *= w0;
		n *= w0;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w1 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint1]);
		n = mul(normal, BoneMatrix[joint1]);
		v *= w1;
		n *= w1;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w2 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint2]);
		n = mul(normal, BoneMatrix[joint2]);
		v *= w2;
		n *= w2;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w3 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint3]);
		n = mul(normal, BoneMatrix[joint3]);
		v *= w3;
		n *= w3;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w4 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint4]);
		n = mul(normal, BoneMatrix[joint4]);
		v *= w4;
		n *= w4;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w5 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint5]);
		n = mul(normal, BoneMatrix[joint5]);
		v *= w5;
		n *= w5;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w6 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint6]);
		n = mul(normal, BoneMatrix[joint6]);
		v *= w6;
		n *= w6;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w7 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint7]);
		n = mul(normal, BoneMatrix[joint7]);
		v *= w7;
		n *= w7;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}

	if (add_weight == true) {
		vtx = vtx_tmp;
		normal = normal_tmp;
	}

	vtx = mul(vtx, MatTransform);
	normal = mul(normal, MatNormalTransform);
	OUT.VtxPos = vtx.xyz;
	vtx = mul(vtx, MatWorldShadowMap);
	vtx = mul(vtx, MatViewShadowMap);
	vtx = mul(vtx, MatProjShadowMap);
	OUT.Pos = vtx;
	OUT.Normal = normal.xyz;

	OUT.Color = float4(0, 0, 0, 1);
	OUT.Color = IN.Color;
	OUT.Tex = IN.Tex;

	return OUT;
}

VertexOut vs_main6(VertexIn_1 IN) {

	//g[VF[_pimain1Ɠj

	VertexOut OUT;

	float4 vtx = float4(IN.Pos, 1.0f);
	float4 normal = float4(IN.Normal, 1.0f);
	float4 vtx_tmp = float4(0, 0, 0, 0);
	float4 normal_tmp = float4(0, 0, 0, 0);

	vtx = mul(vtx, BindShapeMatrix);
	normal = mul(normal, BindShapeMatrix);

	int joint0 = (int)(IN.Weight0.x + 0.0001f);
	int joint1 = (int)(IN.Weight1.x + 0.0001f);
	int joint2 = (int)(IN.Weight2.x + 0.0001f);
	int joint3 = (int)(IN.Weight3.x + 0.0001f);
	int joint4 = (int)(IN.Weight4.x + 0.0001f);
	int joint5 = (int)(IN.Weight5.x + 0.0001f);
	int joint6 = (int)(IN.Weight6.x + 0.0001f);
	int joint7 = (int)(IN.Weight7.x + 0.0001f);

	float w0 = clamp(IN.Weight0.y, 0.0f, 1.0f);
	float w1 = clamp(IN.Weight1.y, 0.0f, 1.0f);
	float w2 = clamp(IN.Weight2.y, 0.0f, 1.0f);
	float w3 = clamp(IN.Weight3.y, 0.0f, 1.0f);
	float w4 = clamp(IN.Weight4.y, 0.0f, 1.0f);
	float w5 = clamp(IN.Weight5.y, 0.0f, 1.0f);
	float w6 = clamp(IN.Weight6.y, 0.0f, 1.0f);
	float w7 = clamp(IN.Weight7.y, 0.0f, 1.0f);

	bool add_weight = false;
	float4 v = float4(0, 0, 0, 0);
	float4 n = float4(0, 0, 0, 0);

	if (w0 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint0]);
		n = mul(normal, BoneMatrix[joint0]);
		v *= w0;
		n *= w0;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w1 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint1]);
		n = mul(normal, BoneMatrix[joint1]);
		v *= w1;
		n *= w1;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w2 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint2]);
		n = mul(normal, BoneMatrix[joint2]);
		v *= w2;
		n *= w2;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w3 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint3]);
		n = mul(normal, BoneMatrix[joint3]);
		v *= w3;
		n *= w3;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w4 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint4]);
		n = mul(normal, BoneMatrix[joint4]);
		v *= w4;
		n *= w4;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w5 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint5]);
		n = mul(normal, BoneMatrix[joint5]);
		v *= w5;
		n *= w5;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w6 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint6]);
		n = mul(normal, BoneMatrix[joint6]);
		v *= w6;
		n *= w6;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w7 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint7]);
		n = mul(normal, BoneMatrix[joint7]);
		v *= w7;
		n *= w7;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}

	if (add_weight == true) {
		vtx = vtx_tmp;
		normal = normal_tmp;
	}

	vtx = mul(vtx, MatTransform);
	normal = mul(normal, MatNormalTransform);
	OUT.VtxPos = vtx.xyz;
	vtx = mul(vtx, MatWorld);
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;
	OUT.Normal = normal.xyz;

	OUT.Color = IN.Color;
	OUT.Tex = IN.Tex;

	return OUT;
}

/////////////////////////////////////////////////////////////////////////

float4 ps_main1(VertexOut input) : SV_Target0{

	//fBt[YJ[̏o

	float4 color = float4( 0, 0, 0, 0 );
	float4 tex_color = TexDiffuse.Sample(sampleDiffuse, input.Tex);
	if( tex_color.a < 0.001f )
		tex_color = float4(Diffuse.r, Diffuse.g, Diffuse.b, Diffuse.a);

	float4 light_color = float4(0, 0, 0, 1);
	float4 dif = float4(0, 0, 0, 0);
	float4 amb = float4(0, 0, 0, 0);
	float4 spec = float4(0, 0, 0, 0);

	float specular_power = 0.3f;
	float ambient_power = 0.3f;
	float3 L = normalize(LightPos[0].xyz);
	float3 N = normalize(input.Normal.xyz);
	float LN = saturate(dot(L, N));
	float3 R = normalize(2 * LN * N - normalize(LightPos[0].xyz));
	float3 V = normalize(EyePos.xyz);
	float RV = saturate(dot(R, V));
	amb += tex_color * ambient_power;
	dif += LN * tex_color * 1.2f;
	spec += specular_power * pow(RV, 5.0);

	float power = LightColor[0].w * 2.0f;

	light_color.rgb += power * LightColor[0].rgb;

	color.rgb = light_color.rgb * (amb.rgb + dif.rgb + spec.rgb);
	color.rgb = clamp(color.rgb, 0.0f, 1.0f);
	color.a = tex_color.a;

	//VhE}bv
	float4 shadow_tex = mul(float4(input.VtxPos.xyz, 1.0f), MatViewShadowMap);
	shadow_tex =  mul(shadow_tex, MatProjShadowMap);
	float2 uv = shadow_tex.xy;
	uv /= shadow_tex.w;
	uv.x = 0.5f * uv.x + 0.5f;
	uv.y = -0.5f * uv.y + 0.5f;

	float depth = shadow_tex.z / shadow_tex.w;

	float4 D = TexShadowMap.Sample(sampleDiffuse, uv);
	if (D.x + 0.00001f < depth && uv.x > 0.0f && uv.x < 1.0f && uv.y > 0.0f && uv.y < 1.0f )
		color.rgb /= 1.4f;

	return color;
}

float4 ps_main2(VertexOut input) : SV_Target0{

	//ŏIIȃ_O̍

	float4 tex_color = TexDiffuse.Sample(sampleDiffuse, input.Tex);
//	float4 tex_collider = TexCollider.Sample(sampleDiffuse, input.Tex);

	///////////////////////////////////////////
	//LN^[

	//GbW̋E`

	float4 character_color = TexToon.Sample(sampleDiffuse, input.Tex);
	tex_color = character_color * character_color.a + tex_color * (1.0f - character_color.a);
//	tex_color.rgb = tex_color.rgb * (1.0f - tex_collider.a) + tex_collider.rgb * tex_collider.a;
	
/*	float4 character_color = TexToon.Sample(sampleDiffuse, input.Tex);

	float display_width = ShaderParam1.x;

	float tex_x = 1.0f / display_width;
	float tex_y = 1.0f / display_width;

	float4 d_center = TexToonDepth.Sample(sampleDiffuse, input.Tex.xy);
	float4 d0 = TexToonDepth.Sample(sampleDiffuse, input.Tex.xy + float2(-tex_x * 0.8f, -tex_y * 0.8f));
	float4 d1 = TexToonDepth.Sample(sampleDiffuse, input.Tex.xy + float2(0.0f, -tex_y));
	float4 d2 = TexToonDepth.Sample(sampleDiffuse, input.Tex.xy + float2(tex_x * 0.8f, -tex_y * 0.8f));
	float4 d3 = TexToonDepth.Sample(sampleDiffuse, input.Tex.xy + float2(tex_x, 0.0f));
	float4 d4 = TexToonDepth.Sample(sampleDiffuse, input.Tex.xy + float2(tex_x * 0.8f, tex_y * 0.8f));
	float4 d5 = TexToonDepth.Sample(sampleDiffuse, input.Tex.xy + float2(0.0f, tex_y));
	float4 d6 = TexToonDepth.Sample(sampleDiffuse, input.Tex.xy + float2(-tex_x * 0.8f, tex_y * 0.8f));
	float4 d7 = TexToonDepth.Sample(sampleDiffuse, input.Tex.xy + float2(-tex_x, 0.0f));

	float D0 = (d_center.x - d0.x) / max(abs(d4.x - d_center.x), 0.005f);
	float D1 = (d_center.x - d1.x) / max(abs(d5.x - d_center.x), 0.005f);
	float D2 = (d_center.x - d2.x) / max(abs(d6.x - d_center.x), 0.005f);
	float D3 = (d_center.x - d3.x) / max(abs(d7.x - d_center.x), 0.005f);

	float d_max = max(D0, D1);
	d_max = max(d_max, D2);
	d_max = max(d_max, D3);

	if (d_max > 0.12f) {
		character_color.gb *= 0.5;
		character_color.r *= 0.6;
	}

	tex_color = character_color * character_color.a + tex_color * (1.0f - character_color.a);
	tex_color.rgb = tex_color.rgb * ( 1.0f - tex_collider.a ) + tex_collider.rgb * tex_collider.a;
*/

	return tex_color;
}

float4 dist_point_line(float4 p0, float4 p1, float4 pos) {

	float3 vec1 = pos.xyz - p0.xyz;
	float3 vec2 = p1.xyz - p0.xyz;
	float3 n_vec = normalize(vec2.xyz);
	float3 P = p0.xyz + dot(vec1.xyz, n_vec.xyz) * n_vec;
	float dist = length(pos.xyz - P.xyz);

	return float4(P.x, P.y, P.z, dist);
}

float4 dist_line_line(float4 p0, float4 p1, float4 pos0, float4 pos1) {

	float4 m1 = normalize(pos1 - pos0);
	float4 m2 = normalize(p1 - p0);

	float d = abs(dot(pos0.xyz - p0.xyz, cross(m1.xyz, m2.xyz).xyz)) / length(cross(m1.xyz, m2.xyz).xyz);

	float k = dot(m1 - dot(m2, m1) * m2, p0 - pos0) / (1.0f - pow(dot(m1, m2), 2.0f));
	float4 P1 = pos0 + k * m1;

	if (k > 0.0f && k < length(pos1.xyz - pos0.xyz)) {
		P1.w = d;
		return P1;
	}

	float4 P2 = dist_point_line(p0, p1, pos0);
	float4 P3 = dist_point_line(p0, p1, pos1);
	if (P2.w < P3.w)
		return P2;

	return P3;
}

float4 ps_main3(VertexOut input) : SV_Target0{

	float4 color = float4(0, 0, 0, 0);

	input.Tex.x = input.Tex.x * 2.0f - 1.0f;
	input.Tex.y = -input.Tex.y * 2.0f + 1.0f;

	float4 p0 = float4(input.Tex.x, input.Tex.y, -1000, 0.0f);
	float4 p1 = float4(input.Tex.x, input.Tex.y, 1000, 0.0f);

	if (ColliderState.x < 0.001) {
		color.r = 1.0f;
		color.g = 0.0f;
		color.b = 0.0f;
	}
	else if( ColliderState.x < 1.1f ){
		color.r = 0.0f;
		color.g = 0.0f;
		color.b = 1.0f;
	}

	for (int i = 0; i <= 254; i++) {

		int type = (int)(ColliderParam[i].x + 0.00001f);
		float r = ColliderParam[i].y;

		float4 pos1 = ColliderPos[i][0];
		float4 pos2 = ColliderPos[i][1];

		if (type == 0)
			break;
		else if (type == 1 || type == 2) {

			float4 d_pos = dist_point_line(p0, p1, pos1);
			if (d_pos.w < r) {
				color.a += 0.7f;
			}
		}
		else {
			float4 d_pos = dist_line_line(p0, p1, pos1, pos2);
			if (d_pos.w < r) {
				color.a += 0.7f;
			}
		}
	}
	color.a = clamp(color.a, 0.0f, 1.0f);

	return color;
}

float4 ps_main4(VertexOut input) : SV_Target0{

	//fBt[YJ[̏o

	float4 color = float4(0, 0, 0, 0.7f);

	if (ColliderState.x < 0.01f) {
		color.r = 1.0f;
		color.g = 0.0f;
		color.b = 0.0f;
	}
	else if( ColliderState.x < 1.1f ){
		color.r = 0.0f;
		color.g = 0.0f;
		color.b = 1.0f;
	}

	return color;
}

float4 ps_main5(VertexOut input) : SV_Target0{

	return float4(input.Pos.z, 0, 0, 1.0f);
}

PsOutput ps_main6(VertexOut input){

	PsOutput output;

	float4 color = float4(0, 0, 0, 0);
	float4 tex_color = TexDiffuse.Sample(sampleDiffuse, input.Tex);
	if (tex_color.a < 0.001f)
		tex_color = float4(Diffuse.r, Diffuse.g, Diffuse.b, Diffuse.a);

	float4 light_color = float4(0, 0, 0, 1);
	float4 dif = float4(0, 0, 0, 0);
	float4 amb = float4(0, 0, 0, 0);
	float4 spec = float4(0, 0, 0, 0);

	float specular_power = 0.3f;
	float ambient_power = 0.3f;
	float3 L = normalize(LightPos[0].xyz);
	float3 N = normalize(input.Normal.xyz);
	float LN = saturate(dot(L, N));
	float3 R = normalize(2 * LN * N - normalize(LightPos[0].xyz));
	float3 V = normalize(EyePos.xyz);
	float RV = saturate(dot(R, V));
	amb += tex_color * ambient_power;
	dif += LN * tex_color * 1.2f;
	spec += specular_power * pow(RV, 5.0);

	float power = LightColor[0].w * 2.0f;

	light_color.rgb += power * LightColor[0].rgb;

	color.rgb = light_color.rgb * (amb.rgb + dif.rgb + spec.rgb);
	color.rgb = clamp(color.rgb, 0.0f, 1.0f);
	color.a = tex_color.a;

	//VhE}bv
	float4 shadow_tex = mul(float4(input.VtxPos.xyz, 1.0f), MatLight);
	shadow_tex = mul(shadow_tex, MatProjLight);
	float2 uv = shadow_tex.xy;
	uv /= shadow_tex.w;
	uv.x = 0.5f * uv.x + 0.5f;
	uv.y = -0.5f * uv.y + 0.5f;

	float depth = shadow_tex.z / shadow_tex.w;

	float4 D = TexShadowMap.Sample(sampleDiffuse, uv);
	if (D.x + 0.00001f < depth)
		color.rgb /= 1.4f;

	output.Color = float4(color.rgb, 1.0f);
	output.Depth = float4(input.Pos.z / input.Pos.w, 0, 0, 1);

	return output;

/*
	//g[VF[_

	PsOutput output;

	float4 tex_color = TexDiffuse.Sample(sampleDiffuse, input.Tex);
	if (tex_color.a < 0.001f)
		tex_color = float4(Diffuse.r, Diffuse.g, Diffuse.b, Diffuse.a);

	float3 vec1 = normalize(float3( -10, 10, 10 ) - input.VtxPos.xyz);
	float d = dot(vec1, normalize(input.Normal.xyz));
	if (d < -0.1) {
		tex_color.gb *= 0.7f;
		tex_color.r *= 0.8f;
	}
	else if (d < 0.5f) {
		tex_color.gb *= 0.9f;
		tex_color.r *= 0.95f;
	}

	if (tex_color.r < 0.001 && tex_color.g < 0.001 && tex_color.b < 0.001) {
		tex_color = input.Color;
	}
	if (tex_color.r >= 0.98 && tex_color.g >= 0.98 && tex_color.b >= 0.98) {
		tex_color.rgb = 0.96;
	}

	output.Color = float4( tex_color.rgb, 1.0f );
	output.Depth = float4(input.Pos.z / input.Pos.w, 0, 0, 1);

	return output;
*/
}
